/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.mixin;

import io.github.apace100.origins.access.MovingEntity;
import io.github.apace100.origins.access.WaterMovingEntity;
import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.networking.ModPackets;
import io.github.apace100.origins.power.ActionOnLandPower;
import io.github.apace100.origins.power.EntityGlowPower;
import io.github.apace100.origins.power.FireImmunityPower;
import io.github.apace100.origins.power.IgnoreWaterPower;
import io.github.apace100.origins.power.InvisibilityPower;
import io.github.apace100.origins.power.InvulnerablePower;
import io.github.apace100.origins.power.PhasingPower;
import io.github.apace100.origins.power.SwimmingPower;
import io.github.apace100.origins.registry.ModComponentsArchitectury;
import io.netty.buffer.Unpooled;
import java.util.List;
import me.shedaniel.architectury.networking.NetworkManager;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public abstract class EntityMixin
implements MovingEntity {
    @Shadow
    public World field_70170_p;
    @Shadow
    public float field_82151_R;
    @Shadow
    protected boolean field_70122_E;
    @Unique
    private boolean wasGrounded = false;
    private boolean isMoving;
    private float distanceBefore;

    @Inject(method={"isFireImmune"}, at={@At(value="HEAD")}, cancellable=true)
    private void makeFullyFireImmune(CallbackInfoReturnable<Boolean> cir) {
        if (OriginComponent.hasPower((Entity)this, FireImmunityPower.class)) {
            cir.setReturnValue((Object)true);
        }
    }

    @Shadow
    public abstract double func_233571_b_(ITag<Fluid> var1);

    @Shadow
    public abstract Vector3d func_213322_ci();

    @Shadow
    public abstract int func_145782_y();

    @Inject(method={"isTouchingWater"}, at={@At(value="HEAD")}, cancellable=true)
    private void makeEntitiesIgnoreWater(CallbackInfoReturnable<Boolean> cir) {
        if (OriginComponent.hasPower((Entity)this, IgnoreWaterPower.class) && this instanceof WaterMovingEntity && ((WaterMovingEntity)((Object)this)).isInMovementPhase()) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"isGlowing"}, at={@At(value="HEAD")}, cancellable=true)
    @OnlyIn(value=Dist.CLIENT)
    private void makeEntitiesGlow(CallbackInfoReturnable<Boolean> cir) {
        boolean exists;
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        Entity thisEntity = (Entity)this;
        boolean bl = exists = this.field_70170_p != null && this.field_70170_p.func_73045_a(this.func_145782_y()) != null;
        if (player != null && player != thisEntity && thisEntity instanceof LivingEntity && exists && OriginComponent.getPowers((Entity)player, EntityGlowPower.class).stream().anyMatch(p -> p.doesApply(thisEntity))) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"move"}, at={@At(value="INVOKE_STRING", target="Lnet/minecraft/util/profiler/Profiler;push(Ljava/lang/String;)V", args={"ldc=rest"})})
    private void checkWasGrounded(MoverType type, Vector3d movement, CallbackInfo ci) {
        this.wasGrounded = this.field_70122_E;
    }

    @Inject(method={"fall"}, at={@At(value="FIELD", target="Lnet/minecraft/entity/Entity;fallDistance:F", opcode=181, ordinal=0)})
    @OnlyIn(value=Dist.CLIENT)
    private void invokeActionOnSoftLand(double heightDifference, boolean onGround, BlockState landedState, BlockPos landedPosition, CallbackInfo ci) {
        if (!this.wasGrounded && this instanceof PlayerEntity) {
            OriginComponent.getPowers((Entity)this, ActionOnLandPower.class).forEach(ActionOnLandPower::executeAction);
            NetworkManager.sendToServer((ResourceLocation)ModPackets.PLAYER_LANDED, (PacketBuffer)new PacketBuffer(Unpooled.buffer()));
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"isInvulnerableTo"}, cancellable=true)
    private void makeOriginInvulnerable(DamageSource damageSource, CallbackInfoReturnable<Boolean> cir) {
        if (this instanceof PlayerEntity) {
            OriginComponent component = ModComponentsArchitectury.getOriginComponent((Entity)this);
            if (!component.hasAllOrigins()) {
                cir.setReturnValue((Object)true);
            }
            if (component.getPowers(InvulnerablePower.class).stream().anyMatch(inv -> inv.doesApply(damageSource))) {
                cir.setReturnValue((Object)true);
            }
        }
    }

    @Redirect(method={"move"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;isWet()Z"))
    private boolean preventExtinguishingFromSwimming(Entity entity) {
        if (OriginComponent.hasPower(entity, SwimmingPower.class) && entity.func_203007_ba() && !(this.func_233571_b_((ITag<Fluid>)FluidTags.field_206959_a) > 0.0)) {
            return false;
        }
        return entity.func_203008_ap();
    }

    @Inject(at={@At(value="HEAD")}, method={"isInvisible"}, cancellable=true)
    private void phantomInvisibility(CallbackInfoReturnable<Boolean> info) {
        if (OriginComponent.hasPower((Entity)this, InvisibilityPower.class)) {
            info.setReturnValue((Object)true);
        }
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/util/math/BlockPos;<init>(DDD)V")}, method={"pushOutOfBlocks"}, cancellable=true)
    protected void pushOutOfBlocks(double x, double y, double z, CallbackInfo info) {
        List<PhasingPower> powers = OriginComponent.getPowers((Entity)this, PhasingPower.class);
        if (powers.size() > 0 && powers.stream().anyMatch(phasingPower -> phasingPower.doesApply(new BlockPos(x, y, z)))) {
            info.cancel();
        }
    }

    @Inject(method={"move"}, at={@At(value="HEAD")})
    private void saveDistanceTraveled(MoverType type, Vector3d movement, CallbackInfo ci) {
        this.isMoving = false;
        this.distanceBefore = this.field_82151_R;
    }

    @Inject(method={"move"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/profiler/Profiler;pop()V")})
    private void checkIsMoving(MoverType type, Vector3d movement, CallbackInfo ci) {
        if (this.field_82151_R > this.distanceBefore) {
            this.isMoving = true;
        }
    }

    @Override
    public boolean isMoving() {
        return this.isMoving;
    }
}

